/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLEditorKit;
import org.colos.ejs.library.Animation;
import org.colos.ejs.library.Experiment;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Memory;
import org.colos.ejs.library.Model;
import org.colos.ejs.library.MoodleLink;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.MethodWithOneParameter;
import org.colos.ejs.library.control.SpecialRender;
import org.colos.ejs.library.utils.FileUtils;
import org.colos.ejs.library.utils.HtmlPageInfo;
import org.colos.ejs.library.utils.LocaleItem;
import org.colos.ejs.library.utils.LocaleListener;
import org.colos.ejs.library.utils.VideoUtil;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.desktop.OSPDesktop;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.dialogs.DialogsRes;
import org.opensourcephysics.tools.Diagnostics;
import org.opensourcephysics.tools.DiagnosticsForSystem;
import org.opensourcephysics.tools.DiagnosticsForThreads;
import org.opensourcephysics.tools.DiagnosticsForXuggle;
import org.opensourcephysics.tools.EjsTool;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.SnapshotTool;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.XuggleRes;

public abstract class Simulation
extends Animation
implements LocaleListener {
    public static ResourceBundle ejsRes = ResourceBundle.getBundle("org.colos.ejs.library.resources.ejs_res", Locale.getDefault());
    private static final String DEFAULT_STATE_FILENAME = "DefaultState.out";
    private static String pathToLibrary = "";
    private static AWTEventListener focusListener = null;
    private static String homeDir = null;
    private static String userDir = null;
    private boolean isUnderEjs = false;
    private Component parentComponent = null;
    private String parentComponentName = null;
    private String captureElement = null;
    private URL codebase = null;
    private LocaleItem currentLocaleItem = LocaleItem.getDefaultLocaleItem();
    private List<String> stateVariablesList = null;
    private JLabel increaseFontButton;
    private JLabel decreaseFontButton;
    private JLabel openPageButton;
    protected VideoUtil videoUtil;
    private static Hashtable<String, File> resourcesExtracted = new Hashtable();
    private Set<LocaleItem> availableLocales = new HashSet<LocaleItem>();
    private boolean showDescriptionOnStart = true;
    private JFrame descriptionDialog = null;
    private JTabbedPane descriptionPanel = null;
    private List<EditorAndScroll> descriptionPagesList = null;
    private static final String dummy = "";
    private static final Class<?> strClass = "".getClass();
    private static Hashtable<String, Object> memory = new Hashtable();
    protected MoodleLink moodle = null;
    private MethodWithOneParameter _init_ = null;
    private LauncherApplet javascriptControledApplet = null;
    protected JPopupMenu popupMenu = null;
    private JMenu elementsMenu = null;
    private AbstractList<Object> popupMenuExtraEntries = null;
    private Component popupTriggeredBy = null;
    protected Experiment currentExperiment = null;
    JMenuItem snapshotMenuItem;
    private JDialog aboutThisDialog = null;

    public static String getEjsString(String string) {
        try {
            return ejsRes.getString(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string;
        }
    }

    public static String getPathToLibrary() {
        return pathToLibrary;
    }

    public static void setPathToLibrary(String string) {
        try {
            File file = new File(string);
            if (file.exists() && file.isDirectory()) {
                pathToLibrary = string;
            }
        }
        catch (Exception exception) {}
    }

    public static String getUserDir() {
        if (userDir == null) {
            try {
                userDir = System.getProperty("user.dir").replace('\\', '/');
                if (!userDir.endsWith("/")) {
                    userDir = String.valueOf(userDir) + "/";
                }
            }
            catch (Exception exception) {
                return dummy;
            }
        }
        return userDir;
    }

    public static String getHomeDir() {
        if (homeDir == null) {
            try {
                homeDir = System.getProperty("user.home").replace('\\', '/');
                if (!homeDir.endsWith("/")) {
                    homeDir = String.valueOf(homeDir) + "/";
                }
            }
            catch (Exception exception) {
                return dummy;
            }
        }
        return homeDir;
    }

    public static String getTemporaryDir() {
        try {
            return String.valueOf(Simulation.getHomeDir()) + ".Ejs.tmp/";
        }
        catch (Exception exception) {
            return dummy;
        }
    }

    public static File getResourceFile(String string) {
        Resource resource = ResourceLoader.getResource(string);
        if (resource == null) {
            return null;
        }
        File file = resource.getFile();
        if (file != null && file.exists()) {
            return file;
        }
        file = resourcesExtracted.get(string);
        if (file != null) {
            return file;
        }
        int n = string.lastIndexOf(46);
        String string2 = n >= 0 ? string.substring(n) : ".tmp";
        try {
            int n2;
            file = File.createTempFile("ejs_tmp_", string2);
            file.deleteOnExit();
            InputStream inputStream = resource.openInputStream();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            while ((n2 = bufferedInputStream.read()) != -1) {
                fileOutputStream.write(n2);
            }
            bufferedInputStream.close();
            fileOutputStream.close();
            resourcesExtracted.put(string, file);
            System.out.println("Ejs simulation: resource " + string + " extracted into " + file.getAbsolutePath());
            return file;
        }
        catch (Exception exception) {
            System.out.println("Ejs simulation: resource " + string + " could NOT be extracted");
            exception.printStackTrace();
            return null;
        }
    }

    public static File extractToDirectory(String string, File file, boolean bl) {
        try {
            int n;
            File file2 = new File(file, string);
            file2.deleteOnExit();
            file2.getParentFile().mkdirs();
            InputStream inputStream = ResourceLoader.openInputStream(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            while ((n = bufferedInputStream.read()) != -1) {
                fileOutputStream.write(n);
            }
            bufferedInputStream.close();
            fileOutputStream.close();
            if (bl) {
                System.out.println("Ejs simulation: resource " + string + " extracted into " + file2.getAbsolutePath());
            }
            return file2;
        }
        catch (Exception exception) {
            System.out.println("Ejs simulation: resource " + string + " could NOT be extracted");
            exception.printStackTrace();
            return null;
        }
    }

    public static File extractAs(String string, String string2, boolean bl) {
        try {
            int n;
            File file = new File(string2);
            file.deleteOnExit();
            if (file.getParentFile() != null) {
                file.getParentFile().mkdirs();
            }
            InputStream inputStream = ResourceLoader.openInputStream(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            while ((n = bufferedInputStream.read()) != -1) {
                fileOutputStream.write(n);
            }
            bufferedInputStream.close();
            fileOutputStream.close();
            if (bl) {
                System.out.println("Ejs simulation: resource " + string + " extracted into " + file.getAbsolutePath());
            }
            return file;
        }
        catch (Exception exception) {
            System.err.println("Ejs simulation: resource " + string + " could NOT be extracted");
            exception.printStackTrace();
            return null;
        }
    }

    public boolean hasDefaultState() {
        if (this.isMoodleConnected()) {
            return false;
        }
        Resource resource = ResourceLoader.getResource(DEFAULT_STATE_FILENAME);
        return resource != null;
    }

    public boolean readDefaultState() {
        if (this.hasDefaultState()) {
            return this.readVariables(DEFAULT_STATE_FILENAME, null);
        }
        return false;
    }

    public String getResetFilename() {
        return this.resetFile;
    }

    @Override
    protected void userDefinedReset() {
        if (this.resetFile != null) {
            if (this.resetFile.equals(DEFAULT_STATE_FILENAME)) {
                this.readVariables(DEFAULT_STATE_FILENAME, null);
            } else {
                this.readState(this.resetFile);
            }
            if (this.view != null) {
                this.view.reset();
            }
        }
    }

    @Override
    protected void userDefinedViewUpdate() {
        this.videoUtil.captureVideoImage();
    }

    public void captureVideo(String string) {
        this.videoUtil.startVideoTool(this.getView(), string);
    }

    private String getClassname() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private String getModelClassname() {
        String string = this.model.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private void errorMessage(String string) {
        System.err.println(String.valueOf(this.getClassname()) + ": " + string);
    }

    private void errorMessage(Exception exception) {
        System.err.println(String.valueOf(this.getClassname()) + ": Exception caught! Text follows:");
        exception.printStackTrace(System.err);
    }

    public void setParentComponent(Component component) {
        this.parentComponent = component;
    }

    public void setParentComponent(String string) {
        this.parentComponentName = string;
        this.parentComponent = null;
    }

    public Component getParentComponent() {
        if (this.parentComponent == null && this.view != null) {
            this.parentComponent = this.view.getComponent(this.parentComponentName);
        }
        return this.parentComponent;
    }

    public void setCodebase(URL uRL) {
        this.codebase = uRL;
    }

    public URL getCodebase() {
        return this.codebase;
    }

    public void addAvailableLocale(String string) {
        LocaleItem localeItem = LocaleItem.getLocaleItem(string);
        if (localeItem != null) {
            this.availableLocales.add(localeItem);
        } else {
            System.out.println("Warning! Html editor is ignoring unrecognized locale name : " + string + "\n");
        }
    }

    public Set<LocaleItem> getAvailableLocales() {
        return this.availableLocales;
    }

    public String translateString(String string, String string2) {
        return Model._getTranslatorUtil().translateString(string, string2);
    }

    public String translateString(String string) {
        return Model._getTranslatorUtil().translateString(string);
    }

    @Override
    public void setLocaleItem(LocaleItem localeItem) {
        this.setLocaleItem(localeItem, true);
    }

    protected void setLocaleItem(LocaleItem localeItem, boolean bl) {
        this.currentLocaleItem = localeItem;
        Locale locale = localeItem.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ToolsRes.setLocale(locale);
        DisplayRes.setLocale(locale);
        DialogsRes.setLocale(locale);
        ejsRes = ResourceBundle.getBundle("org.colos.ejs.library.resources.ejs_res", locale);
        Model._getTranslatorUtil().setLocaleItem(this.currentLocaleItem);
        this.setViewLocale();
        this.popupMenu = null;
        this.resetDescriptionPages();
        if (bl) {
            this.model._reset();
        }
    }

    public LocaleItem getLocaleItem() {
        return this.currentLocaleItem;
    }

    public void setLocale(String string) {
        LocaleItem localeItem = LocaleItem.getLocaleItem(string);
        if (localeItem != null) {
            this.setLocaleItem(localeItem);
        } else {
            System.out.println("Warning! Html editor is ignoring unrecognized locale name : " + string + "\n");
            this.setLocaleItem(LocaleItem.getDefaultItem());
        }
    }

    public Locale getLocale() {
        Locale locale = this.currentLocaleItem.getLocale();
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    protected void setViewLocale() {
        this.elementsMenu = null;
        this.popupMenuExtraEntries = null;
        if (this.view instanceof EjsControl) {
            ((EjsControl)((Object)this.view)).addElementsMenuEntries();
        }
        this.view.update();
        this.view.finalUpdate();
    }

    private void createDescriptionDialog(int n, int n2) {
        this.descriptionPanel = new JTabbedPane();
        final Border border = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        final Border border2 = BorderFactory.createLineBorder(new Color(128, 64, 255), 1);
        Cursor cursor = Cursor.getPredefinedCursor(12);
        this.increaseFontButton = new JLabel(ResourceLoader.getIcon("/org/colos/ejs/library/resources/fontUp.gif"));
        this.increaseFontButton.setBorder(border);
        this.increaseFontButton.setCursor(cursor);
        this.increaseFontButton.setToolTipText(DisplayRes.getString("DrawingFrame.IncreaseFontSize_menu_item"));
        this.increaseFontButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(final MouseEvent mouseEvent) {
                ((JComponent)mouseEvent.getComponent()).setBorder(border2);
                Timer timer = new Timer(1000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ((JComponent)mouseEvent.getComponent()).setBorder(border);
                    }
                });
                timer.setRepeats(false);
                timer.start();
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (Simulation.this.descriptionPagesList == null) {
                                return;
                            }
                            for (EditorAndScroll editorAndScroll : Simulation.this.descriptionPagesList) {
                                Font font = editorAndScroll.editorPane.getFont();
                                float f = font.getSize2D() * 1.1f;
                                editorAndScroll.editorPane.setFont(font.deriveFont(f));
                            }
                        }
                    });
                }
            }
        });
        this.decreaseFontButton = new JLabel(ResourceLoader.getIcon("/org/colos/ejs/library/resources/fontDown.gif"));
        this.decreaseFontButton.setBorder(border);
        this.decreaseFontButton.setCursor(cursor);
        this.decreaseFontButton.setToolTipText(DisplayRes.getString("DrawingFrame.DecreaseFontSize_menu_item"));
        this.decreaseFontButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(final MouseEvent mouseEvent) {
                ((JComponent)mouseEvent.getComponent()).setBorder(border2);
                Timer timer = new Timer(1000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ((JComponent)mouseEvent.getComponent()).setBorder(border);
                    }
                });
                timer.setRepeats(false);
                timer.start();
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (Simulation.this.descriptionPagesList == null) {
                                return;
                            }
                            for (EditorAndScroll editorAndScroll : Simulation.this.descriptionPagesList) {
                                Font font = editorAndScroll.editorPane.getFont();
                                float f = Math.max(10.0f, font.getSize2D() / 1.1f);
                                editorAndScroll.editorPane.setFont(font.deriveFont(f));
                            }
                        }
                    });
                }
            }
        });
        this.openPageButton = new JLabel(ResourceLoader.getIcon("/org/colos/ejs/library/resources/fullScreen.gif"));
        this.openPageButton.setBorder(border);
        this.openPageButton.setCursor(cursor);
        this.openPageButton.setToolTipText(Memory.getResource("DescriptionPages.OpenExternalBrowser"));
        this.openPageButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(final MouseEvent mouseEvent) {
                ((JComponent)mouseEvent.getComponent()).setBorder(border2);
                Timer timer = new Timer(1000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ((JComponent)mouseEvent.getComponent()).setBorder(border);
                    }
                });
                timer.setRepeats(false);
                timer.start();
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (Simulation.this.descriptionPagesList == null) {
                                return;
                            }
                            Component component = Simulation.this.descriptionPanel.getSelectedComponent();
                            for (EditorAndScroll editorAndScroll : Simulation.this.descriptionPagesList) {
                                if (component != editorAndScroll.scrollPane) continue;
                                if (!Simulation.this.openDescriptionPageInBrowser(editorAndScroll.name)) {
                                    JOptionPane.showMessageDialog(Simulation.this.openPageButton, Memory.getResource("DescriptionPages.ErrorOpeningFiles"), Memory.getResource("Error"), 0);
                                }
                                return;
                            }
                            System.err.println("DescriptionPages : Could not find the selected page.");
                        }
                    });
                }
            }
        });
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(this.increaseFontButton);
        jPanel.add(this.decreaseFontButton);
        jPanel.add(this.openPageButton);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EtchedBorder(1));
        JComponent jComponent = Model._getTranslatorUtil().getSelectorComponent(this);
        if (jComponent != null) {
            jComponent.setBorder(new EmptyBorder(0, 0, 0, 2));
            jPanel2.add((Component)jPanel, "West");
            jPanel2.add((Component)jComponent, "East");
        } else {
            jPanel2.add((Component)jPanel, "Center");
        }
        this.descriptionDialog = new JFrame(String.valueOf(Memory.getResource("DescriptionFor")) + " " + this.getModelClassname());
        this.descriptionDialog.getContentPane().add((Component)this.descriptionPanel, "Center");
        this.descriptionDialog.getContentPane().add((Component)jPanel2, "South");
        if (n <= 0) {
            n = 600;
        }
        if (n2 <= 0) {
            n2 = 400;
        }
        Rectangle rectangle = EjsControl.getDefaultScreenBounds();
        n = Math.min(n, rectangle.width - 10);
        n2 = Math.min(n2, rectangle.height - 10);
        this.descriptionDialog.setLocation(rectangle.x + (rectangle.width - n) / 2, rectangle.y + (rectangle.height - n2) / 2);
    }

    public void addDescriptionPage(String string, int n, int n2, boolean bl) {
        HtmlPageInfo htmlPageInfo = this.model._getHtmlPageInfo(string, this.currentLocaleItem);
        if (htmlPageInfo == null) {
            JOptionPane.showMessageDialog(this.popupTriggeredBy, "Html file not found: " + string, "Description Error", 0);
            return;
        }
        Resource resource = ResourceLoader.getResource(htmlPageInfo.getLink());
        if (resource == null) {
            System.err.println("Add description page error : Couldn't find description file: " + string);
            System.err.println("Link = " + htmlPageInfo.getLink());
            return;
        }
        if (this.descriptionDialog == null) {
            this.createDescriptionDialog(n, n2);
        }
        try {
            JEditorPane jEditorPane = new JEditorPane(){};
            HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
            jEditorPane.setEditorKit(hTMLEditorKit);
            jEditorPane.setDocument(hTMLEditorKit.createDefaultDocument());
            jEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            jEditorPane.setEditable(false);
            jEditorPane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        Simulation.this.openURL(hyperlinkEvent.getSource(), hyperlinkEvent.getURL(), Simulation.this.getView().getComponent(Simulation.this.getMainWindow()), Simulation.this.model._getApplet() != null);
                    }
                }
            });
            jEditorPane.setPage(resource.getURL());
            JScrollPane jScrollPane = new JScrollPane(jEditorPane);
            jScrollPane.setPreferredSize(new Dimension(n, n2));
            if (this.descriptionPagesList == null) {
                this.descriptionPagesList = new ArrayList<EditorAndScroll>();
            }
            EditorAndScroll editorAndScroll = new EditorAndScroll(string, jEditorPane, jScrollPane);
            editorAndScroll.setVisible(bl);
            this.descriptionPagesList.add(editorAndScroll);
        }
        catch (IOException iOException) {
            System.err.println("Attempted to read a bad URL: " + resource.getURL());
        }
    }

    public void addDescriptionPage(String string, String string2, int n, int n2) {
        this.addDescriptionPage(string2, n, n2, true);
    }

    public void setDescriptionPageVisible(String string, boolean bl) {
        if (this.descriptionPagesList == null) {
            return;
        }
        for (EditorAndScroll editorAndScroll : this.descriptionPagesList) {
            if (!editorAndScroll.name.equals(string)) continue;
            if (editorAndScroll.isVisible() == bl) break;
            editorAndScroll.setVisible(bl);
            this.recreateDescriptionPanel();
            break;
        }
    }

    protected void recreateDescriptionPanel() {
        if (this.descriptionPanel == null) {
            return;
        }
        this.descriptionPanel.removeAll();
        for (EditorAndScroll editorAndScroll : this.descriptionPagesList) {
            HtmlPageInfo htmlPageInfo;
            if (!editorAndScroll.isVisible() || (htmlPageInfo = this.model._getHtmlPageInfo(editorAndScroll.name, this.currentLocaleItem)) == null) continue;
            this.descriptionPanel.add(htmlPageInfo.getTitle(), editorAndScroll.scrollPane);
        }
        this.descriptionDialog.pack();
        if (this.descriptionPanel.getTabCount() <= 0) {
            this.descriptionDialog.setVisible(false);
            this.showDescriptionOnStart = false;
        }
    }

    @Override
    protected void resetDescriptionPages() {
        if (this.descriptionPagesList == null) {
            return;
        }
        try {
            for (EditorAndScroll editorAndScroll : this.descriptionPagesList) {
                HtmlPageInfo htmlPageInfo = this.model._getHtmlPageInfo(editorAndScroll.name, this.currentLocaleItem);
                if (htmlPageInfo == null) continue;
                Resource resource = ResourceLoader.getResource(htmlPageInfo.getLink());
                URL uRL = resource.getURL();
                if (editorAndScroll.editorPane.getPage() == uRL) continue;
                editorAndScroll.editorPane.setPage(uRL);
                this.descriptionPanel.setTitleAt(this.descriptionPanel.indexOfComponent(editorAndScroll.scrollPane), htmlPageInfo.getTitle());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.increaseFontButton != null) {
            this.descriptionDialog.setTitle(String.valueOf(Memory.getResource("DescriptionFor")) + " " + this.getModelClassname());
            this.increaseFontButton.setToolTipText(DisplayRes.getString("DrawingFrame.IncreaseFontSize_menu_item"));
            this.decreaseFontButton.setToolTipText(DisplayRes.getString("DrawingFrame.DecreaseFontSize_menu_item"));
            this.openPageButton.setToolTipText(Memory.getResource("DescriptionPages.OpenExternalBrowser"));
        }
    }

    public void showDescriptionAtStartUp(boolean bl) {
        this.showDescriptionOnStart = bl;
    }

    public void showDescription() {
        this.showDescription(true);
    }

    public void showDescription(boolean bl) {
        if (this.descriptionDialog != null) {
            this.descriptionDialog.setVisible(bl);
        }
    }

    public URL getDescriptionPageURL(String string) {
        HtmlPageInfo htmlPageInfo = this.model._getHtmlPageInfo(string, this.currentLocaleItem);
        if (htmlPageInfo == null) {
            return null;
        }
        return ResourceLoader.getResource(htmlPageInfo.getLink()).getURL();
    }

    public boolean openDescriptionPagesInBrowser() {
        File file = this.extractResources();
        if (file == null) {
            return false;
        }
        boolean bl = false;
        for (EditorAndScroll editorAndScroll : this.descriptionPagesList) {
            HtmlPageInfo htmlPageInfo = this.model._getHtmlPageInfo(editorAndScroll.name, this.currentLocaleItem);
            if (htmlPageInfo == null) {
                System.err.println("DescriptionPages : Could not find the page: " + editorAndScroll.name);
                bl = true;
            }
            if (this.openExternalBrowser(file, htmlPageInfo)) continue;
            bl = true;
        }
        return bl;
    }

    public boolean openDescriptionPageInBrowser(String string) {
        File file = this.extractResources();
        if (file == null) {
            return false;
        }
        HtmlPageInfo htmlPageInfo = this.model._getHtmlPageInfo(string, this.currentLocaleItem);
        if (htmlPageInfo == null) {
            System.err.println("DescriptionPages : Could not find the page: " + string);
            return false;
        }
        return this.openExternalBrowser(file, htmlPageInfo);
    }

    private File extractResources() {
        if (OSPRuntime.appletMode) {
            return null;
        }
        File file = new File(String.valueOf(Simulation.getTemporaryDir()) + "DescriptionPages/");
        if (!file.exists() && !file.mkdirs()) {
            System.err.println("DescriptionPages : Could not create directory : " + file.getAbsolutePath());
            JOptionPane.showMessageDialog(this.openPageButton, Memory.getResource("DescriptionPages.CannotExtractFiles"), Memory.getResource("Error"), 0);
            return null;
        }
        for (String string : this.model._getClassEjsResources()) {
            if (Simulation.extractToDirectory(string, file, false) != null) continue;
            return null;
        }
        Simulation.extractToDirectory("/_ejs_library/css/ejsPage.css", file, false);
        return file;
    }

    private boolean openExternalBrowser(File file, HtmlPageInfo htmlPageInfo) {
        String string = htmlPageInfo.getLink();
        if (string.startsWith("./")) {
            string = String.valueOf(this.model._getClassModelDirectory()) + string.substring(2);
        }
        if (Simulation.extractToDirectory(string, file, false) == null) {
            return false;
        }
        string = "file:///" + FileUtils.correctUrlString(String.valueOf(FileUtils.getPath(file)) + string);
        return OSPDesktop.displayURL(string);
    }

    public void openURL(Object object, URL uRL, Component component, boolean bl) {
        try {
            String string = uRL.toString();
            int n = string.indexOf("jar!");
            if (n < 0) {
                this.tellTheUserToWait();
                OSPDesktop.displayURL(uRL.toString());
                return;
            }
            if ((string = string.substring(n + 4)).startsWith("/")) {
                string = string.substring(1);
            }
            if (bl) {
                this.tellTheUserToWait();
                OSPDesktop.displayURL(uRL.toString());
            } else {
                boolean bl2;
                String string2 = string.toLowerCase();
                boolean bl3 = bl2 = string2.indexOf(".html") < 0 && string2.indexOf(".htm") < 0;
                if (bl2) {
                    File file = Simulation.getResourceFile(string);
                    if (file == null) {
                        JOptionPane.showMessageDialog(component, String.valueOf(ejsRes.getString("Simulation.ErrorWhenOpening")) + ":\n  " + uRL.getFile());
                    } else {
                        this.tellTheUserToWait();
                        OSPDesktop.displayURL(file.toURI().toString());
                    }
                } else {
                    int n2 = string.indexOf(35);
                    String string3 = n2 >= 0 ? string.substring(0, n2) : string;
                    for (EditorAndScroll editorAndScroll : this.descriptionPagesList) {
                        if (!string3.equals(editorAndScroll.name)) continue;
                        this.descriptionPanel.setSelectedComponent(editorAndScroll.scrollPane);
                        if (editorAndScroll.editorPane.getPage() != uRL) {
                            editorAndScroll.editorPane.setPage(uRL);
                        }
                        if (uRL.getRef() != null) {
                            editorAndScroll.editorPane.scrollToReference(uRL.getRef());
                        }
                        return;
                    }
                    ((JEditorPane)object).setPage(uRL);
                }
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(component, String.valueOf(ejsRes.getString("Simulation.ErrorWhenOpening")) + ":\n  " + uRL.getFile());
            exception.printStackTrace();
        }
    }

    private void tellTheUserToWait() {
        final JDialog jDialog = new JDialog((Frame)this.descriptionDialog, ejsRes.getString("Simulation.Opening"));
        final JLabel jLabel = new JLabel(ejsRes.getString("Simulation.Opening"));
        jLabel.setBorder(new EmptyBorder(5, 5, 5, 5));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                jDialog.getContentPane().setLayout(new BorderLayout());
                jDialog.getContentPane().add((Component)jLabel, "Center");
                jDialog.validate();
                jDialog.pack();
                jDialog.setLocationRelativeTo(Simulation.this.descriptionDialog);
                jDialog.setModal(false);
                jDialog.setVisible(true);
            }
        });
        Timer timer = new Timer(3000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.setVisible(false);
                jDialog.dispose();
            }
        });
        timer.setRepeats(false);
        timer.start();
    }

    public String getVariable(String string) {
        return this.getVariable(string, ",");
    }

    public String getVariable(String string, String string2) {
        if (this.model == null) {
            return null;
        }
        try {
            Field field = this.model.getClass().getField(string);
            if (field.getType().isArray()) {
                String string3 = dummy;
                Object object = field.get(this.model);
                int n = Array.getLength(object);
                int n2 = 0;
                while (n2 < n) {
                    string3 = n2 > 0 ? String.valueOf(string3) + string2 + Array.get(object, n2).toString() : String.valueOf(string3) + Array.get(object, n2).toString();
                    ++n2;
                }
                return string3;
            }
            return field.get(this.model).toString();
        }
        catch (Exception exception) {
            this.errorMessage(exception);
            return null;
        }
    }

    public boolean setVariable(String string, String string2) {
        return this.setVariable(string, string2, ",");
    }

    public boolean setVariable(String string, String string2, String string3) {
        if (this.model == null) {
            return false;
        }
        try {
            Field field = this.model.getClass().getField(string);
            if (field.getType().isArray()) {
                boolean bl = true;
                Object object = field.get(this.model);
                int n = 0;
                int n2 = Array.getLength(object);
                Class<?> clazz = field.getType().getComponentType();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
                if (n2 < stringTokenizer.countTokens()) {
                    this.errorMessage("Warning: there are less elements in the array than values provided!");
                } else if (n2 > stringTokenizer.countTokens()) {
                    this.errorMessage("Warning: there are more elements in the array than values provided!");
                }
                while (stringTokenizer.hasMoreTokens() && n < n2) {
                    String string4 = stringTokenizer.nextToken();
                    if (clazz.equals(Double.TYPE)) {
                        Array.setDouble(object, n, Double.parseDouble(string4));
                    } else if (clazz.equals(Float.TYPE)) {
                        Array.setFloat(object, n, Float.parseFloat(string4));
                    } else if (clazz.equals(Byte.TYPE)) {
                        Array.setByte(object, n, Byte.parseByte(string4));
                    } else if (clazz.equals(Short.TYPE)) {
                        Array.setShort(object, n, Short.parseShort(string4));
                    } else if (clazz.equals(Integer.TYPE)) {
                        Array.setInt(object, n, Integer.parseInt(string4));
                    } else if (clazz.equals(Long.TYPE)) {
                        Array.setLong(object, n, Long.parseLong(string4));
                    } else if (clazz.equals(Boolean.TYPE)) {
                        if (string4.trim().toLowerCase().equals("true")) {
                            Array.setBoolean(object, n, true);
                        } else {
                            Array.setBoolean(object, n, false);
                        }
                    } else if (clazz.equals(Character.TYPE)) {
                        Array.setChar(object, n, string4.charAt(0));
                    } else if (clazz.equals(strClass)) {
                        Array.set(object, n, string4);
                    } else {
                        bl = false;
                    }
                    ++n;
                }
                return bl;
            }
            Class<?> clazz = field.getType();
            if (clazz.equals(Double.TYPE)) {
                field.setDouble(this.model, Double.parseDouble(string2));
            } else if (clazz.equals(Float.TYPE)) {
                field.setFloat(this.model, Float.parseFloat(string2));
            } else if (clazz.equals(Byte.TYPE)) {
                field.setByte(this.model, Byte.parseByte(string2));
            } else if (clazz.equals(Short.TYPE)) {
                field.setShort(this.model, Short.parseShort(string2));
            } else if (clazz.equals(Integer.TYPE)) {
                field.setInt(this.model, Integer.parseInt(string2));
            } else if (clazz.equals(Long.TYPE)) {
                field.setLong(this.model, Long.parseLong(string2));
            } else if (clazz.equals(Boolean.TYPE)) {
                if (string2.trim().toLowerCase().equals("true")) {
                    field.setBoolean(this.model, true);
                } else {
                    field.setBoolean(this.model, false);
                }
            } else if (clazz.equals(Character.TYPE)) {
                field.setChar(this.model, string2.charAt(0));
            } else if (clazz.equals(strClass)) {
                field.set(this.model, string2);
            } else {
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            this.errorMessage(exception);
            return false;
        }
    }

    public boolean setVariables(String string) {
        return this.setVariables(string, ";", ",");
    }

    public boolean setVariables(String string, String string2, String string3) {
        boolean bl = true;
        String string4 = dummy;
        String string5 = dummy;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string6 = stringTokenizer.nextToken();
            int n = string6.indexOf(61);
            if (n < 0) {
                bl = false;
                continue;
            }
            string4 = string6.substring(0, n).trim();
            boolean bl2 = this.setVariable(string4, string5 = string6.substring(n + 1).trim(), string3);
            if (bl2) continue;
            bl = false;
        }
        this.update();
        return bl;
    }

    public LauncherApplet initMoodle() {
        LauncherApplet launcherApplet = this.model._getApplet();
        if (launcherApplet == null) {
            return null;
        }
        try {
            String string = launcherApplet.getParameter("init");
            if (string != null) {
                this._init_ = new MethodWithOneParameter(0, launcherApplet._model, string, null, null, launcherApplet);
                this._init_.invoke(0, launcherApplet);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return launcherApplet;
    }

    public boolean isMoodleConnected() {
        if (this.moodle == null) {
            return false;
        }
        return this.moodle.isConnected();
    }

    private boolean javascriptControlMode() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isImageFormatSupported(String string) {
        try {
            String[] stringArray = ImageIO.getWriterFormatNames();
            int n = 0;
            while (true) {
                if (n >= stringArray.length) {
                    return false;
                }
                if (stringArray[n].equalsIgnoreCase(string)) {
                    return true;
                }
                ++n;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    protected void setUnderEjs(boolean bl) {
        this.isUnderEjs = bl;
    }

    public boolean isUnderEjs() {
        return this.isUnderEjs;
    }

    public List<Experiment> getExperiments() {
        return null;
    }

    public Experiment createExperiment(String string) {
        return null;
    }

    public void runExperiment(Experiment experiment) {
        if (experiment == null) {
            return;
        }
        if (this.currentExperiment != null) {
            this.currentExperiment._abortExperiment();
        }
        this.currentExperiment = experiment;
        experiment._runExperiment();
    }

    public void runExperiment(String string) {
        this.runExperiment(this.createExperiment(string));
    }

    public void killExperiment() {
        if (this.currentExperiment != null) {
            this.currentExperiment._abortExperiment();
        }
        this.currentExperiment = null;
    }

    public void addMenuEntries(List<Object> list) {
        if (this.popupMenuExtraEntries == null) {
            this.popupMenuExtraEntries = new ArrayList<Object>();
        }
        this.popupMenuExtraEntries.addAll(list);
        this.popupMenu = null;
    }

    public void addElementMenuEntries(String string, List<Object> list) {
        Serializable serializable;
        if (this.elementsMenu == null) {
            this.elementsMenu = new JMenu(this.getMenuText("ejs_res:MenuItem.Elements"));
            serializable = new ArrayList();
            serializable.add(this.elementsMenu);
            this.addMenuEntries((List<Object>)((Object)serializable));
        }
        serializable = new JMenu(string);
        for (Object object : list) {
            this.addMenuItem((JComponent)serializable, object);
        }
        this.addMenuItem(this.elementsMenu, serializable);
    }

    public Component getTopLevelComponent(Component component) {
        Component component2 = component;
        while (component2.getParent() != null) {
            component2 = component2.getParent();
        }
        return component2;
    }

    public void getPopupMenu(Component component, String string) {
        this.getPopupMenu(component, -1, -1, string);
    }

    /*
     * WARNING - void declaration
     */
    public void getPopupMenu(final Component component, int n, int n2, String string) {
        this.captureElement = string;
        if (this.popupMenu == null) {
            Object object;
            Object object222;
            boolean bl = true;
            try {
                System.getProperty("user.home");
            }
            catch (Exception exception) {
                bl = false;
            }
            this.popupMenu = new JPopupMenu();
            List<Experiment> list = this.getExperiments();
            if (list != null) {
                object222 = new JMenu(this.getMenuText("tools_res:MenuItem.Experiments"));
                for (final Experiment object3 : list) {
                    String string2 = this.translateString(object3._getName());
                    String string3 = this.translateString(object3._getDescription());
                    AbstractAction abstractAction = new AbstractAction(string2){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            Simulation.this.runExperiment(object3);
                        }
                    };
                    abstractAction.putValue("ShortDescription", string3);
                    ((JMenu)object222).add(abstractAction);
                }
                this.popupMenu.add((JMenuItem)object222);
                object = new JMenuItem(this.getMenuText("tools_res:MenuItem.KillExperiment"));
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Simulation.this.killExperiment();
                    }
                });
                this.popupMenu.add((JMenuItem)object);
                this.popupMenu.addSeparator();
            }
            if (this.descriptionDialog != null) {
                this.popupMenu.add(new AbstractAction(Memory.getResource("ShowDescription")){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Simulation.this.descriptionDialog.setVisible(true);
                    }
                });
            }
            if (this.popupMenuExtraEntries != null && this.popupMenuExtraEntries.size() > 0) {
                for (Object object222 : this.popupMenuExtraEntries) {
                    this.addMenuItem(this.popupMenu, object222);
                }
                this.popupMenu.addSeparator();
            }
            this.extraAction2();
            if (bl || this.isMoodleConnected()) {
                void var9_12;
                object222 = new JMenu(this.getMenuText("ejs_res:MenuItem.SnapshotTools"));
                ((JMenu)object222).add(new AbstractAction(this.getMenuText("tools_res:MenuItem.Snapshot")){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        boolean bl = Simulation.this.isPlaying();
                        if (bl) {
                            Simulation.this.pause();
                        }
                        Simulation.this.saveImageAs(Simulation.this.captureElement);
                        if (bl) {
                            Simulation.this.play();
                        }
                    }
                });
                this.popupMenu.add((JMenuItem)object222);
                this.snapshotMenuItem = new JMenuItem(this.getMenuText("ejs_res:MenuItem.SnapshotTool"));
                this.snapshotMenuItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ((DrawingPanel)Simulation.this.view.getElement(Simulation.this.captureElement).getVisual()).snapshot();
                    }
                });
                ((JMenu)object222).add(this.snapshotMenuItem);
                if (this.videoUtil.isFullClass()) {
                    ((JMenu)object222).add(new AbstractAction(this.getMenuText("ejs_res:MenuItem.TakeEPSSnapshot")){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            Simulation.this.videoUtil.takeSnapshot(Simulation.this.getTopLevelComponent(component));
                        }
                    });
                    ((JMenu)object222).add(new AbstractAction(this.getMenuText("ejs_res:MenuItem.TakeEPSSnapshotWindow")){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            focusListener = new AWTEventListener(){

                                @Override
                                public void eventDispatched(AWTEvent aWTEvent) {
                                    WindowEvent windowEvent = (WindowEvent)aWTEvent;
                                    if (windowEvent.getID() == 207) {
                                        Toolkit.getDefaultToolkit().removeAWTEventListener(focusListener);
                                        (this).Simulation.this.videoUtil.takeSnapshot(windowEvent.getWindow());
                                    }
                                }
                            };
                            System.out.println("Put the focus on the window you want to capture");
                            Toolkit.getDefaultToolkit().addAWTEventListener(focusListener, 64L);
                        }
                    });
                    ((JMenu)object222).add(new AbstractAction(this.getMenuText("tools_res:MenuItem.Video")){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            Simulation.this.videoUtil.startVideoTool(Simulation.this.getView(), Simulation.this.captureElement);
                        }
                    });
                }
                object = new JMenu(this.getMenuText("ejs_res:MenuItem.StateIO"));
                ((JMenu)object).add(new AbstractAction(this.getMenuText("tools_res:MenuItem.SaveState")){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Simulation.this.saveState(null);
                    }
                });
                try {
                    boolean bl2 = OSPRuntime.isLauncherMode();
                }
                catch (Exception exception) {
                    boolean bl2 = false;
                }
                if (!this.isUnderEjs && var9_12 == false && !this.isMoodleConnected()) {
                    ((JMenu)object).add(new AbstractAction(this.getMenuText("ejs_res:MenuItem.SaveDefaultState")){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            File file = null;
                            try {
                                URL uRL = Simulation.class.getProtectionDomain().getCodeSource().getLocation();
                                file = new File(uRL.toURI());
                            }
                            catch (Exception exception) {
                                JFileChooser jFileChooser = OSPRuntime.createChooser("JAR", new String[]{"jar"});
                                String string = OSPRuntime.chooseFilename(jFileChooser, Simulation.this.getParentComponent(), false);
                                if (string == null) {
                                    return;
                                }
                                file = new File(string);
                            }
                            Simulation.this.saveDefaultStateToJar(file, null);
                        }
                    });
                }
                ((JMenu)object).add(new AbstractAction(this.getMenuText("tools_res:MenuItem.ReadState")){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Simulation.this.updateView = false;
                        Simulation.this.readState(null);
                        Simulation.this.updateView = true;
                        Simulation.this.updateAfterModelAction();
                    }
                });
                ((JMenu)object).add(new AbstractAction(this.getMenuText("ejs_res:MenuItem.DefaultResetState")){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Simulation.this.resetFile = null;
                        Simulation.this.reset();
                    }
                });
                this.popupMenu.add((JMenuItem)object);
            }
            object222 = new JMenu(ejsRes.getString("MenuItem.GUI"));
            Model._getTranslatorUtil().addToMenu((JMenu)object222, this);
            object = new JMenu(DisplayRes.getString("DrawingFrame.Font_menu_title"));
            ((JMenu)object).add(new AbstractAction(DisplayRes.getString("DrawingFrame.IncreaseFontSize_menu_item")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FontSizer.levelUp();
                    for (String string : Simulation.this.getWindowsList()) {
                        FontSizer.setFonts(Simulation.this.getView().getComponent(string), FontSizer.getLevel());
                    }
                }
            });
            ((JMenu)object).add(new AbstractAction(DisplayRes.getString("DrawingFrame.DecreaseFontSize_menu_item")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FontSizer.levelDown();
                    for (String string : Simulation.this.getWindowsList()) {
                        FontSizer.setFonts(Simulation.this.getView().getComponent(string), FontSizer.getLevel());
                    }
                }
            });
            ((JMenu)object222).add((JMenuItem)object);
            this.popupMenu.add((JMenuItem)object222);
            this.popupMenu.addSeparator();
            this.popupMenu.add(new AbstractAction(Memory.getResource("Simulation.AboutThisSimulation")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Simulation.this.aboutThisSimulation(component);
                }
            });
            if (bl && EjsTool.hasEjsModel(this.getModel().getClass())) {
                this.popupMenu.add(new AbstractAction(ejsRes.getString("Simulation.OpenEjsModel")){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        String string;
                        try {
                            string = System.getProperty("launcher.password");
                        }
                        catch (Exception exception) {
                            string = null;
                        }
                        boolean bl = EjsTool.runEjs(Simulation.this.getModel().getClass(), string);
                        if (!Simulation.this.model._isApplet() && !OSPRuntime.isLauncherMode() && bl) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {
                                interruptedException.printStackTrace();
                            }
                            System.exit(0);
                        }
                    }
                });
            }
            if (!this.isUnderEjs && bl && !this.model._isApplet()) {
                this.popupMenu.add(new AbstractAction(Memory.getResource("CreateHTMLPage")){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Simulation.this.createHTMLpage(Simulation.this.getJarName());
                    }
                });
            }
            if (bl) {
                JMenu jMenu = new JMenu(Memory.getResource("Diagnostics.Menu"));
                jMenu.add(new AbstractAction(this.getMenuText("tools_res:Diagnostics.OS.About.Title")){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Diagnostics.aboutOS();
                    }
                });
                jMenu.add(new AbstractAction(this.getMenuText("tools_res:Diagnostics.Java.About.Title")){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Diagnostics.aboutJava();
                    }
                });
                jMenu.add(new AbstractAction(this.getMenuText("ejs_res:Diagnostics.Properties")){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DiagnosticsForSystem.aboutSystem(null);
                    }
                });
                jMenu.add(new AbstractAction(this.getMenuText("ejs_res:Diagnostics.Threads")){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DiagnosticsForThreads.aboutThreads();
                    }
                });
                jMenu.add(new AbstractAction(this.getMenuText("tools_res:Diagnostics.Java3D.About.Title")){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        Diagnostics.aboutJava3D();
                    }
                });
                jMenu.add(new AbstractAction(this.getMenuText("xuggle_res:Xuggle.Dialog.AboutXuggle.Title")){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        DiagnosticsForXuggle.aboutXuggle();
                    }
                });
                this.popupMenu.add(jMenu);
            }
            this.popupMenu.add(new AbstractAction("OSP " + ToolsRes.getString("MenuItem.Log")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OSPLog oSPLog = OSPLog.getOSPLog();
                    if (oSPLog != null) {
                        oSPLog.setLocationRelativeTo(Simulation.this.parentComponent);
                    }
                    OSPLog.showLog();
                }
            });
        }
        if (this.snapshotMenuItem != null) {
            this.snapshotMenuItem.setVisible(component instanceof DrawingPanel);
        }
        Model._getTranslatorUtil().refreshMenu();
        this.popupTriggeredBy = component;
        if (n >= 0 && n2 >= 0) {
            this.popupMenu.show(component, n, n2);
        } else {
            this.popupMenu.show(component, (component.getWidth() - this.popupMenu.getWidth()) / 2, (component.getHeight() - this.popupMenu.getHeight()) / 2);
        }
    }

    public JPanel makeLabel(String string, Set<JComponent> set) {
        JLabel jLabel = new JLabel(ejsRes.getString(string), 4);
        if (set != null) {
            set.add(jLabel);
        }
        jLabel.setBorder(new EmptyBorder(4, 2, 0, 2));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)jLabel, "North");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setBorder(new EmptyBorder(0, 0, 0, 0));
        jPanel2.add((Component)jPanel, "West");
        return jPanel2;
    }

    public static JTextComponent makeField(Container container, int n, int n2) {
        if (n < 2) {
            JTextField jTextField = new JTextField(n2);
            container.add((Component)jTextField, "Center");
            jTextField.setEditable(false);
            return jTextField;
        }
        JTextArea jTextArea = new JTextArea(n, n2);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        jPanel.add((Component)jScrollPane, "Center");
        container.add((Component)jPanel, "Center");
        return jTextArea;
    }

    private static void getTag(String string, String string2, JTextComponent jTextComponent) {
        String string3 = "<" + string2 + "><![CDATA[";
        String string4 = "]]></" + string2 + ">";
        int n = string.indexOf(string3);
        if (n < 0) {
            return;
        }
        int n2 = string.indexOf(string4);
        if (n2 < n) {
            return;
        }
        jTextComponent.setText(string.substring(n + string3.length(), n2));
    }

    public void aboutThisSimulation(Component component) {
        if (this.aboutThisDialog == null) {
            String string;
            String string2 = this.getModel()._getClassEjsModel();
            int n = string2.indexOf(46);
            if (n > 0) {
                string2 = string2.substring(0, n);
            }
            if ((string = ResourceLoader.getString(string2 = String.valueOf(string2) + ".metadata")) == null) {
                System.err.println("Metadata file not found for " + string2);
                return;
            }
            int n2 = 35;
            HashSet<JComponent> hashSet = new HashSet<JComponent>();
            JPanel jPanel = this.makeLabel("Simulation.Title", hashSet);
            JTextComponent jTextComponent = Simulation.makeField(jPanel, 1, n2);
            Simulation.getTag(string, "Title", jTextComponent);
            JPanel jPanel2 = this.makeLabel("Simulation.Author", hashSet);
            JTextComponent jTextComponent2 = Simulation.makeField(jPanel2, 1, n2);
            Simulation.getTag(string, "Author", jTextComponent2);
            JPanel jPanel3 = this.makeLabel("Simulation.Keywords", hashSet);
            JTextComponent jTextComponent3 = Simulation.makeField(jPanel3, 1, n2);
            Simulation.getTag(string, "Keywords", jTextComponent3);
            JPanel jPanel4 = this.makeLabel("Simulation.Level", hashSet);
            JTextComponent jTextComponent4 = Simulation.makeField(jPanel4, 1, n2);
            Simulation.getTag(string, "Level", jTextComponent4);
            JPanel jPanel5 = this.makeLabel("Simulation.Language", hashSet);
            JTextComponent jTextComponent5 = Simulation.makeField(jPanel5, 1, n2);
            Simulation.getTag(string, "Language", jTextComponent5);
            JPanel jPanel6 = this.makeLabel("Simulation.Abstract", hashSet);
            JTextComponent jTextComponent6 = Simulation.makeField(jPanel6, 7, n2);
            Simulation.getTag(string, "Abstract", jTextComponent6);
            int n3 = 0;
            int n4 = 0;
            for (JComponent jComponent : hashSet) {
                n3 = Math.max(n3, jComponent.getPreferredSize().width);
                n4 = Math.max(n4, jComponent.getPreferredSize().height);
            }
            Dimension dimension = new Dimension(n3, n4);
            for (JComponent jComponent : hashSet) {
                jComponent.setPreferredSize(dimension);
            }
            Box box = Box.createVerticalBox();
            box.setBorder(BorderFactory.createEmptyBorder(1, 0, 1, 0));
            box.add(jPanel);
            box.add(jPanel2);
            box.add(jPanel3);
            box.add(jPanel4);
            box.add(jPanel5);
            JPanel jPanel7 = new JPanel(new BorderLayout());
            jPanel7.add((Component)box, "North");
            jPanel7.add((Component)jPanel6, "Center");
            jPanel7.setBorder(new EtchedBorder(0));
            this.aboutThisDialog = new JDialog();
            this.aboutThisDialog.setTitle(Memory.getResource("Simulation.AboutThisSimulation"));
            this.aboutThisDialog.getContentPane().setLayout(new BorderLayout());
            this.aboutThisDialog.getContentPane().add((Component)jPanel7, "Center");
            this.aboutThisDialog.setModal(false);
            this.aboutThisDialog.setResizable(true);
            this.aboutThisDialog.pack();
        }
        this.aboutThisDialog.setLocationRelativeTo(component);
        this.aboutThisDialog.setVisible(true);
    }

    private String getMenuText(String string) {
        String string2 = string.startsWith("ejs_res:") ? ejsRes.getString(string.substring(string.indexOf(58) + 1)) : (string.startsWith("tools_res:") ? ToolsRes.getString(string.substring(string.indexOf(58) + 1)) : (string.startsWith("display_res:") ? DisplayRes.getString(string.substring(string.indexOf(58) + 1)) : (string.startsWith("xuggle_res:") ? XuggleRes.getString(string.substring(string.indexOf(58) + 1)) : ToolsRes.getString(string))));
        if (string2.startsWith("!") && string2.endsWith("!")) {
            string2 = DisplayRes.getString(string);
        }
        if (string2.startsWith("!") && string2.endsWith("!")) {
            string2 = string;
        }
        return string2;
    }

    private void processMenuTexts(Object object) {
        if (object instanceof JMenu) {
            JMenu jMenu = (JMenu)object;
            jMenu.setText(this.getMenuText(jMenu.getActionCommand()));
            int n = 0;
            int n2 = jMenu.getItemCount();
            while (n < n2) {
                this.processMenuTexts(jMenu.getItem(n));
                ++n;
            }
        } else if (object instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)object;
            jMenuItem.setText(this.getMenuText(jMenuItem.getActionCommand()));
        }
    }

    private void addMenuItem(JComponent jComponent, Object object) {
        if (object instanceof Action) {
            final Action action = (Action)object;
            String string = (String)action.getValue("Name");
            String string2 = this.getMenuText(string);
            AbstractAction abstractAction = new AbstractAction(string2){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    action.actionPerformed(actionEvent);
                }
            };
            abstractAction.putValue("ShortDescription", string2);
            if (jComponent instanceof JMenu) {
                ((JMenu)jComponent).add(abstractAction);
            } else if (jComponent instanceof JPopupMenu) {
                ((JPopupMenu)jComponent).add(abstractAction);
            }
        } else if (object instanceof JMenu) {
            JMenu jMenu = (JMenu)object;
            this.processMenuTexts(jMenu);
            if (jComponent instanceof JMenu) {
                ((JMenu)jComponent).add(jMenu);
            } else if (jComponent instanceof JPopupMenu) {
                ((JPopupMenu)jComponent).add(jMenu);
            }
        } else if (object instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)object;
            this.processMenuTexts(jMenuItem);
            if (jComponent instanceof JMenu) {
                ((JMenu)jComponent).add(jMenuItem);
            } else if (jComponent instanceof JPopupMenu) {
                ((JPopupMenu)jComponent).add(jMenuItem);
            }
        }
    }

    public List<String> getWindowsList() {
        return new ArrayList<String>();
    }

    public String getMainWindow() {
        return null;
    }

    public String getJarName() {
        URL uRL = this.getClass().getResource(String.valueOf(this.getClass().getSimpleName()) + ".class");
        if (uRL != null) {
            try {
                URLConnection uRLConnection = uRL.openConnection();
                if (uRLConnection instanceof JarURLConnection) {
                    JarURLConnection jarURLConnection = (JarURLConnection)uRLConnection;
                    String string = jarURLConnection.getJarFileURL().getPath();
                    int n = string.lastIndexOf(47);
                    if (n >= 0) {
                        string = string.substring(n + 1);
                    }
                    return string;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    public void createHTMLpage(String string) {
        String string2;
        JFileChooser jFileChooser = OSPRuntime.createChooser("HTML", new String[]{"html"});
        jFileChooser.setSelectedFile(new File(String.valueOf(this.getModelClassname()) + ".html"));
        String string3 = OSPRuntime.chooseFilename(jFileChooser, this.popupTriggeredBy, true);
        if (string3 == null) {
            return;
        }
        if (string3.lastIndexOf(46) < 0) {
            string3 = String.valueOf(string3) + ".html";
        }
        Component component = this.getView().getComponent(this.getMainWindow());
        Dimension dimension = new Dimension(100, 100);
        if (component != null) {
            dimension = component.getSize();
        }
        if ((string2 = this.getClass().getName()).endsWith("Simulation")) {
            string2 = string2.substring(0, string2.length() - 10);
        }
        string2 = String.valueOf(string2) + "Applet.class";
        String string4 = this.getModelClassname();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>\n");
        stringBuffer.append("  <head>\n");
        stringBuffer.append("    <title>" + string4 + " HTML</title>\n");
        stringBuffer.append("  </head>\n");
        stringBuffer.append("  <body >\n");
        stringBuffer.append("    <applet code=\"" + string2 + "\"\n");
        stringBuffer.append("            codebase=\".\" archive=\"" + string + "\"\n");
        stringBuffer.append("            name=\"" + string4 + "\"  id=\"" + string4 + "\"\n");
        stringBuffer.append("            width=\"" + dimension.width + "\" height=\"" + dimension.height + "\">\n");
        stringBuffer.append("      <param name=\"permissions\" value=\"sandbox\">\n");
        stringBuffer.append("  </applet>\n");
        stringBuffer.append("  </body>\n");
        stringBuffer.append("</html>\n");
        try {
            FileWriter fileWriter = new FileWriter(string3);
            fileWriter.write(stringBuffer.toString());
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this.popupTriggeredBy, "Error saving file: " + string3, "File Error", 0);
        }
    }

    public boolean saveImage(String string) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        DecimalFormat decimalFormat = new DecimalFormat("00");
        String string2 = String.valueOf(gregorianCalendar.get(1)) + decimalFormat.format(gregorianCalendar.get(2)) + decimalFormat.format(gregorianCalendar.get(5)) + "_" + decimalFormat.format(gregorianCalendar.get(11)) + decimalFormat.format(gregorianCalendar.get(12)) + decimalFormat.format(gregorianCalendar.get(13));
        return this.saveImage(String.valueOf(this.getClassname()) + "_" + string2 + ".jpg", string);
    }

    public boolean saveImageAs(String string) {
        return this.saveImage(null, string);
    }

    public boolean saveImage(String string, String string2) {
        if (this.view == null) {
            return false;
        }
        ControlElement controlElement = this.view.getElement(string2);
        if (controlElement == null) {
            System.err.println("Component not found: " + string2);
            return false;
        }
        Component component = controlElement.getComponent();
        if (this.isMoodleConnected() || this.javascriptControlMode()) {
            OutputStream outputStream;
            block20: {
                boolean bl;
                Object object;
                BufferedImage bufferedImage;
                block19: {
                    if (component instanceof JFrame) {
                        component = ((JFrame)component).getContentPane();
                    } else if (component instanceof JDialog) {
                        component = ((JDialog)component).getContentPane();
                    }
                    bufferedImage = new BufferedImage(component.getWidth(), component.getHeight(), 5);
                    if (controlElement instanceof SpecialRender) {
                        ((SpecialRender)((Object)controlElement)).render(bufferedImage);
                    } else {
                        object = bufferedImage.getGraphics();
                        component.paint((Graphics)object);
                        ((Graphics)object).dispose();
                    }
                    if (string == null) {
                        string = String.valueOf(this.getModelClassname()) + ".gif";
                    }
                    if (this.isMoodleConnected()) {
                        return this.moodle.saveImage(string, "GIF image", bufferedImage) != null;
                    }
                    try {
                        object = "jpg";
                        int n = string.lastIndexOf(46);
                        if (n >= 0) {
                            object = string.substring(n + 1).toLowerCase();
                        } else {
                            string = String.valueOf(string) + "." + (String)object;
                        }
                        bl = Simulation.isImageFormatSupported((String)object);
                        if (bl || this.videoUtil.isFullClass() && "gif".equalsIgnoreCase((String)object)) break block19;
                        System.err.println("Format not supported : " + (String)object);
                        return false;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return false;
                    }
                }
                outputStream = null;
                outputStream = this.javascriptControlMode() || string.startsWith("ejs:") ? new ByteArrayOutputStream() : new FileOutputStream(string);
                boolean bl2 = true;
                bl2 = bl ? ImageIO.write((RenderedImage)bufferedImage, (String)object, outputStream) : this.videoUtil.writeGIF(outputStream, bufferedImage);
                outputStream.close();
                if (bl2) break block20;
                return false;
            }
            if (string.startsWith("ejs:")) {
                memory.put(string, ((ByteArrayOutputStream)outputStream).toByteArray());
            } else if (this.javascriptControlMode()) {
                this.javascriptControledApplet.setImageByteArray(((ByteArrayOutputStream)outputStream).toByteArray());
            }
            return true;
        }
        return SnapshotTool.getTool().saveImage(string, component, null);
    }

    public void processArguments(String[] stringArray) {
        LauncherApplet launcherApplet = this.model._getApplet();
        boolean bl = false;
        if (launcherApplet != null) {
            try {
                String string = launcherApplet.getParameter("initialState");
                if (string != null) {
                    bl = this.readState(string, launcherApplet.getCodeBase());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (stringArray != null && stringArray.length > 0) {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].toLowerCase().endsWith(".xml")) {
                    this.resetFile = stringArray[n];
                    bl = this.readState(this.resetFile);
                } else if (stringArray[n].equals("-_initialState")) {
                    this.resetFile = stringArray[++n];
                    bl = this.readState(this.resetFile);
                } else if (stringArray[n].equals("-_noDescription")) {
                    this.showDescriptionOnStart = false;
                }
                ++n;
            }
        }
        if (!bl && !this.isMoodleConnected() && ResourceLoader.getResource(DEFAULT_STATE_FILENAME) != null) {
            OSPLog.fine("Reading default state from jar DefaultState.out");
            this.readVariables(DEFAULT_STATE_FILENAME, null);
            this.resetFile = DEFAULT_STATE_FILENAME;
            if (this.view != null) {
                this.view.reset();
            }
        }
        if (launcherApplet == null) {
            boolean bl2;
            boolean bl3 = bl2 = !this.isUnderEjs;
            if (OSPRuntime.isLauncherMode()) {
                bl2 = false;
            } else {
                try {
                    if ("true".equals(System.getProperty("osp_launcher"))) {
                        bl2 = false;
                    }
                }
                catch (Exception exception) {}
            }
            if (bl2 && this.showDescriptionOnStart) {
                this.showDescription();
            }
        }
    }

    public static List<String> toArrayList(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ;,");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    public List<String> getStateVariablesList() {
        return this.stateVariablesList;
    }

    public void setStateVariablesList(List<String> list) {
        this.stateVariablesList = list;
    }

    public void setStateVariablesList(String string) {
        this.stateVariablesList = Simulation.toArrayList(string);
    }

    public boolean saveState(String string) {
        return this.saveVariables(string, this.stateVariablesList);
    }

    public boolean readState(String string) {
        return this.readVariables(string, this.stateVariablesList);
    }

    public boolean readState(String string, URL uRL) {
        return this.readVariables(string, this.stateVariablesList);
    }

    public boolean saveVariables(String string, String string2) {
        return this.saveVariables(string, Simulation.toArrayList(string2));
    }

    public boolean readVariables(String string, URL uRL, String string2) {
        return this.readVariables(string, Simulation.toArrayList(string2));
    }

    public boolean readVariables(String string, URL uRL, List<String> list) {
        return this.readVariables(string, list);
    }

    public boolean readVariables(String string, List<String> list) {
        boolean bl;
        if (this.model == null) {
            return false;
        }
        if (this.isMoodleConnected()) {
            if ((string = this.moodle.readXML(string)).equals("url:")) {
                return false;
            }
        } else if (string == null) {
            JFileChooser jFileChooser = OSPRuntime.createChooser("XML", new String[]{"xml"});
            jFileChooser.setSelectedFile(new File(String.valueOf(this.getModelClassname()) + "_Variables.xml"));
            string = OSPRuntime.chooseFilename(jFileChooser, this.popupTriggeredBy, false);
            if (string == null) {
                return false;
            }
        }
        if (bl = this.justReadVariables(string, list)) {
            if (this.view != null) {
                this.view.initialize();
                this.view.update();
            }
            this.updateAfterModelAction();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive exception aggregation
     */
    private boolean justReadVariables(String string, List<String> list) {
        try {
            Object object;
            Object object2;
            Object object3;
            boolean bl = true;
            URLConnection uRLConnection = null;
            Reader reader = null;
            if (string.startsWith("ejs:")) {
                bl = memory.get(string) != null;
            } else if (string.startsWith("url:")) {
                object3 = string.substring(4);
                try {
                    uRLConnection = new URL((String)object3).openConnection();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    bl = false;
                }
            } else {
                reader = ResourceLoader.openReader(string);
                boolean bl2 = bl = reader != null;
            }
            if (!bl) {
                this.errorMessage("File does not exist " + string);
                return false;
            }
            object3 = null;
            ObjectInputStream objectInputStream = null;
            if (string.toLowerCase().endsWith(".xml")) {
                void var8_14;
                Object var8_10 = null;
                Reader reader2 = null;
                if (uRLConnection != null) {
                    reader2 = new InputStreamReader((InputStream)uRLConnection.getContent());
                } else if (string.startsWith("ejs:")) {
                    reader2 = new CharArrayReader((char[])memory.get(string));
                } else if (this.isMoodleConnected()) {
                    String string2 = this.moodle.readXML(string);
                } else {
                    reader2 = reader;
                }
                if (reader2 != null) {
                    object2 = new LineNumberReader(reader2);
                    object = new StringBuffer();
                    String string3 = ((LineNumberReader)object2).readLine();
                    while (string3 != null) {
                        ((StringBuffer)object).append(String.valueOf(string3) + "\n");
                        string3 = ((LineNumberReader)object2).readLine();
                    }
                    reader2.close();
                    String string4 = ((StringBuffer)object).toString();
                }
                if (!((XMLControlElement)(object3 = new XMLControlElement(this.getClass()))).readXMLForClass((String)var8_14, this.getClass())) {
                    return true;
                }
            } else {
                void var8_18;
                if (uRLConnection != null) {
                    InputStream inputStream = uRLConnection.getInputStream();
                } else if (string.startsWith("ejs:")) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])memory.get(string));
                } else {
                    InputStream inputStream = ResourceLoader.openInputStream(string);
                }
                if (var8_18 == null) {
                    return false;
                }
                objectInputStream = new ObjectInputStream(new BufferedInputStream((InputStream)var8_18));
            }
            Field[] fieldArray = this.model.getClass().getFields();
            if (list == null) {
                int n = 0;
                while (n < fieldArray.length) {
                    object2 = fieldArray[n].get(this.model);
                    if (object2 == null || object2 instanceof Serializable) {
                        if (object3 != null) {
                            object = ((XMLControlElement)object3).getObject(fieldArray[n].getName());
                            if (object != null) {
                                fieldArray[n].set(this.model, object);
                            }
                        } else if (objectInputStream != null) {
                            object = objectInputStream.readObject();
                            fieldArray[n].set(this.model, object);
                        }
                    }
                    ++n;
                }
            } else {
                int n = 0;
                int n2 = list.size();
                while (n < n2) {
                    object = list.get(n).trim();
                    int n3 = 0;
                    while (n3 < fieldArray.length) {
                        Object object4 = fieldArray[n3].get(this.model);
                        if ((object4 == null || object4 instanceof Serializable) && fieldArray[n3].getName().equals(object)) {
                            if (object3 != null) {
                                Object object5 = ((XMLControlElement)object3).getObject((String)object);
                                if (object5 == null) break;
                                fieldArray[n3].set(this.model, object5);
                                break;
                            }
                            if (objectInputStream == null) break;
                            fieldArray[n3].set(this.model, objectInputStream.readObject());
                            break;
                        }
                        ++n3;
                    }
                    ++n;
                }
            }
            if (objectInputStream != null) {
                objectInputStream.close();
            }
            return true;
        }
        catch (Exception exception) {
            this.errorMessage("Error when trying to read " + string);
            exception.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this.getParentComponent(), exception.getLocalizedMessage());
            return false;
        }
    }

    public boolean saveVariables(String string, List<String> list) {
        Object object;
        Object object2;
        if (this.model == null) {
            return false;
        }
        boolean bl = true;
        if (string == null) {
            if (this.isMoodleConnected()) {
                string = String.valueOf(this.getModelClassname()) + "_Variables.xml";
            } else {
                object2 = OSPRuntime.createChooser("XML", new String[]{"xml"});
                ((JFileChooser)object2).setSelectedFile(new File(String.valueOf(this.getModelClassname()) + "_Variables.xml"));
                object = new MyXMLAccessory((JFileChooser)object2);
                ((JFileChooser)object2).setAccessory((JComponent)object);
                ((JFileChooser)object2).addActionListener(new ActionListener((MyXMLAccessory)object){
                    private final /* synthetic */ MyXMLAccessory val$accesory;
                    {
                        this.val$accesory = myXMLAccessory;
                    }

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        JFileChooser jFileChooser = (JFileChooser)actionEvent.getSource();
                        String string = actionEvent.getActionCommand();
                        if (string.equals("ApproveSelection")) {
                            File file = jFileChooser.getSelectedFile();
                            String string2 = file.getName();
                            boolean bl = false;
                            if (this.val$accesory.saveAsXML()) {
                                if (!string2.toLowerCase().endsWith(".xml")) {
                                    jFileChooser.setSelectedFile(new File(file.getParent(), String.valueOf(string2) + ".xml"));
                                    bl = true;
                                }
                            } else if (string2.toLowerCase().endsWith(".xml")) {
                                jFileChooser.setSelectedFile(new File(file.getParent(), String.valueOf(string2) + ".bin"));
                                bl = true;
                            }
                            if (bl) {
                                JOptionPane.showMessageDialog(Simulation.this.popupTriggeredBy, String.valueOf(ejsRes.getString("Simulation.XMLFileRenamed")) + ":\n  " + jFileChooser.getSelectedFile().getName());
                            }
                        }
                    }
                });
                string = OSPRuntime.chooseFilename((JFileChooser)object2, this.popupTriggeredBy, true);
                if (string == null) {
                    return false;
                }
                bl = ((MyXMLAccessory)object).saveAsXML();
            }
        } else {
            bl = string.toLowerCase().endsWith(".xml");
        }
        try {
            int n;
            Object object3;
            object2 = null;
            object = null;
            ObjectOutputStream objectOutputStream = null;
            if (bl) {
                object2 = new XMLControlElement(this.getClass());
            } else {
                object = this.javascriptControlMode() || string.startsWith("ejs:") || this.isMoodleConnected() ? new ByteArrayOutputStream() : new FileOutputStream(string);
                object3 = new BufferedOutputStream((OutputStream)object);
                objectOutputStream = new ObjectOutputStream((OutputStream)object3);
            }
            object3 = this.model.getClass().getFields();
            if (list == null) {
                n = 0;
                while (n < ((Field[])object3).length) {
                    Object object4 = object3[n].get(this.model);
                    if (object4 == null || object4 instanceof Serializable) {
                        if (object2 != null) {
                            ((XMLControlElement)object2).setValue(object3[n].getName(), object4);
                        } else if (objectOutputStream != null) {
                            objectOutputStream.writeObject(object4);
                        }
                    }
                    ++n;
                }
            } else {
                n = 0;
                int n2 = list.size();
                while (n < n2) {
                    String string2 = list.get(n).trim();
                    int n3 = 0;
                    while (n3 < ((Field[])object3).length) {
                        Object object5 = object3[n3].get(this.model);
                        if ((object5 == null || object5 instanceof Serializable) && object3[n3].getName().equals(string2)) {
                            if (object2 != null) {
                                ((XMLControlElement)object2).setValue(object3[n3].getName(), object3[n3].get(this.model));
                                break;
                            }
                            if (objectOutputStream == null) break;
                            objectOutputStream.writeObject(object3[n3].get(this.model));
                            break;
                        }
                        ++n3;
                    }
                    ++n;
                }
            }
            if (object2 != null) {
                if (this.isMoodleConnected()) {
                    return this.moodle.saveXML(string, "XML file", ((XMLControlElement)object2).toXML()) != null;
                }
                Writer writer = string.startsWith("ejs:") ? new CharArrayWriter() : new FileWriter(string);
                ((XMLControlElement)object2).write(writer);
                if (string.startsWith("ejs:")) {
                    memory.put(string, ((CharArrayWriter)writer).toCharArray());
                }
            } else {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
                if (object != null) {
                    if (this.isMoodleConnected()) {
                        return this.moodle.saveBinary(string, "Binary data", ((ByteArrayOutputStream)object).toByteArray()) != null;
                    }
                    if (string.startsWith("ejs:")) {
                        memory.put(string, ((ByteArrayOutputStream)object).toByteArray());
                    } else if (this.javascriptControlMode()) {
                        this.javascriptControledApplet.setStateByteArray(((ByteArrayOutputStream)object).toByteArray());
                    }
                }
            }
            return true;
        }
        catch (Exception exception) {
            this.errorMessage("Error when trying to save " + string);
            exception.printStackTrace(System.err);
            return false;
        }
    }

    private void addFileToJar(JarOutputStream jarOutputStream, String string, File file) throws Exception {
        int n;
        byte[] byArray = new byte[1024];
        FileInputStream fileInputStream = new FileInputStream(file);
        jarOutputStream.putNextEntry(new JarEntry(string));
        while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
            jarOutputStream.write(byArray, 0, n);
        }
        ((InputStream)fileInputStream).close();
        jarOutputStream.closeEntry();
    }

    public static boolean isDisplayable(String string) {
        return !string.toLowerCase().startsWith("http://");
    }

    public boolean saveDefaultStateToJar(File file, String string) {
        String string2;
        File file2;
        Object object;
        HashSet<File> hashSet;
        File file3;
        block22: {
            File file4;
            Object object2;
            Object object3;
            block21: {
                if (OSPRuntime.isLauncherMode()) {
                    OSPLog.warning("Simulation cannot save state to JAR when in Launcher mode. Ignored!");
                    return false;
                }
                file3 = File.createTempFile(DEFAULT_STATE_FILENAME, null);
                file3.delete();
                boolean bl = this.saveVariables(file3.getAbsolutePath(), (List<String>)null);
                if (bl) break block21;
                JOptionPane.showMessageDialog(this.getParentComponent(), "Cannot save data file", "Could not create temp file", 0);
                return false;
            }
            hashSet = new HashSet<File>();
            if (string != null) {
                object3 = new StringTokenizer(string, ";,");
                while (((StringTokenizer)object3).hasMoreTokens()) {
                    object = ((StringTokenizer)object3).nextToken();
                    if (!Simulation.isDisplayable((String)object)) continue;
                    object2 = ResourceLoader.getResource((String)object);
                    file4 = null;
                    if (object2 != null) {
                        file4 = ((Resource)object2).getFile();
                    }
                    if (file4 == null || !file4.exists()) {
                        if (object2 == null || ((Resource)object2).openReader() == null) {
                            JOptionPane.showMessageDialog(this.getParentComponent(), String.valueOf(ejsRes.getString("Simulation.CantFindExtraFile")) + " " + (String)object, ejsRes.getString("Simulation.IgnoringExtraFile"), 2);
                            continue;
                        }
                        JOptionPane.showMessageDialog(this.getParentComponent(), String.valueOf(ejsRes.getString("Simulation.ExtraFileAlreadyIn")) + " " + (String)object + "\n" + ejsRes.getString("Simulation.RenameDocument"), ejsRes.getString("Simulation.IgnoringExtraFile"), 2);
                        continue;
                    }
                    hashSet.add(file4);
                }
            }
            object3 = new JPanel(new BorderLayout());
            object = new JCheckBox(Memory.getResource("CreateHTMLPage"), false);
            ((Container)object3).add((Component)object, "North");
            object2 = String.valueOf(FileUtils.getPlainName(file)) + "_StateAdded.jar";
            file4 = new File((String)object2);
            int n = 2;
            while (file4.exists()) {
                object2 = String.valueOf(FileUtils.getPlainName(file)) + "_StateAdded_" + n + ".jar";
                file4 = new File((String)object2);
                ++n;
            }
            file2 = new File(file.getParentFile(), (String)object2);
            JFileChooser jFileChooser = OSPRuntime.createChooser("JAR", new String[]{"jar"});
            jFileChooser.setSelectedFile(file2);
            jFileChooser.setAccessory((JComponent)object3);
            string2 = OSPRuntime.chooseFilename(jFileChooser, this.getParentComponent(), true);
            if (string2 != null) break block22;
            return false;
        }
        try {
            if (string2.lastIndexOf(46) < 0) {
                string2 = String.valueOf(string2) + ".jar";
            }
            file2 = new File(string2);
            JarInputStream jarInputStream = new JarInputStream(new FileInputStream(file));
            JarFile jarFile = new JarFile(file);
            JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(file2), jarFile.getManifest());
            HashSet<File> hashSet2 = new HashSet<File>();
            JarEntry jarEntry = jarInputStream.getNextJarEntry();
            while (jarEntry != null) {
                int n;
                String object5 = jarEntry.getName();
                if (object5.equals(DEFAULT_STATE_FILENAME)) {
                    OSPLog.fine("Saving state to JAR : removing previous state file " + object5);
                    jarEntry = jarInputStream.getNextJarEntry();
                    continue;
                }
                String string3 = object5.toLowerCase();
                if (string3.startsWith("meta-inf/") && (string3.endsWith(".sf") || string3.endsWith(".rsa") || string3.endsWith(".dsa"))) {
                    OSPLog.fine("Saving state to JAR : Ignoring signature file : " + object5);
                    jarEntry = jarInputStream.getNextJarEntry();
                    continue;
                }
                boolean bl = false;
                for (File file4 : hashSet) {
                    if (!file4.getName().equals(object5)) continue;
                    int n2 = JOptionPane.showConfirmDialog(this.getParentComponent(), "File already exists in JAR:" + object5 + "\nDo you want to overwrite it?", "Conflict with existing file", 0);
                    if (n2 == 1) {
                        hashSet2.add(file4);
                        break;
                    }
                    bl = true;
                    break;
                }
                if (bl) {
                    jarEntry = jarInputStream.getNextJarEntry();
                    continue;
                }
                byte[] byArray = new byte[1024];
                jarOutputStream.putNextEntry(new JarEntry(object5));
                while ((n = jarInputStream.read(byArray)) > 0) {
                    jarOutputStream.write(byArray, 0, n);
                }
                jarEntry = jarInputStream.getNextJarEntry();
            }
            jarInputStream.close();
            hashSet.removeAll(hashSet2);
            this.addFileToJar(jarOutputStream, DEFAULT_STATE_FILENAME, file3);
            file3.delete();
            for (File file5 : hashSet) {
                this.addFileToJar(jarOutputStream, file5.getName(), file5);
            }
            jarOutputStream.close();
            jarFile.close();
            if (((AbstractButton)object).isSelected()) {
                this.createHTMLpage(file2.getName());
            }
            return true;
        }
        catch (Exception exception) {
            this.errorMessage("Error when trying to save state to " + file.getName());
            exception.printStackTrace(System.err);
            return false;
        }
    }

    public String getVariablesXML(String string) {
        return this.getVariablesXML(Simulation.toArrayList(string));
    }

    public String getVariablesXML(List<String> list) {
        if (this.model == null) {
            return null;
        }
        try {
            int n;
            XMLControlElement xMLControlElement = new XMLControlElement(this.getClass());
            Field[] fieldArray = this.model.getClass().getFields();
            if (list == null) {
                n = 0;
                while (n < fieldArray.length) {
                    Object object = fieldArray[n].get(this.model);
                    if (object == null || object instanceof Serializable) {
                        xMLControlElement.setValue(fieldArray[n].getName(), fieldArray[n].get(this.model));
                    }
                    ++n;
                }
            } else {
                n = 0;
                int n2 = list.size();
                while (n < n2) {
                    String string = list.get(n).trim();
                    int n3 = 0;
                    while (n3 < fieldArray.length) {
                        Object object = fieldArray[n3].get(this.model);
                        if ((object == null || object instanceof Serializable) && fieldArray[n3].getName().equals(string)) {
                            xMLControlElement.setValue(fieldArray[n3].getName(), fieldArray[n3].get(this.model));
                            break;
                        }
                        ++n3;
                    }
                    ++n;
                }
            }
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            xMLControlElement.write(charArrayWriter);
            return charArrayWriter.toString();
        }
        catch (Exception exception) {
            this.errorMessage("Error when trying to get XML of variables!");
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public boolean saveText(String string, String string2) {
        try {
            Writer writer;
            if (string.startsWith("ejs:")) {
                writer = new CharArrayWriter();
            } else {
                if (this.isMoodleConnected()) {
                    if (string.toLowerCase().endsWith(".xml")) {
                        return this.moodle.saveXML(string, "XML file", string2) != null;
                    }
                    return this.moodle.saveText(string, "Text file", string2) != null;
                }
                writer = new FileWriter(string);
            }
            BufferedWriter bufferedWriter = new BufferedWriter(writer);
            bufferedWriter.write(string2);
            bufferedWriter.close();
            if (string.startsWith("ejs:")) {
                memory.put(string, ((CharArrayWriter)writer).toCharArray());
            }
            return true;
        }
        catch (Exception exception) {
            System.err.println("Error when trying to save" + string);
            exception.printStackTrace(System.err);
            return false;
        }
    }

    public boolean saveText(String string, StringBuffer stringBuffer) {
        return this.saveText(string, stringBuffer.toString());
    }

    public String readText(String string) {
        return this.readText(string, null);
    }

    public String readText(String string, URL uRL) {
        if (this.isMoodleConnected() || string.startsWith("url:")) {
            String string2 = dummy;
            if (this.isMoodleConnected()) {
                string2 = string.toLowerCase().endsWith(".xml") ? this.moodle.readXML(string) : this.moodle.readText(string);
                if (string2.equals("url:")) {
                    return null;
                }
            } else if (string.startsWith("url:")) {
                string2 = string.substring(4);
                if (uRL != null && !string2.startsWith("http:")) {
                    string2 = uRL + string2;
                }
            }
            try {
                URL uRL2 = new URL(string2);
                InputStream inputStream = (InputStream)uRL2.getContent();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                String string3 = null;
                StringBuffer stringBuffer = new StringBuffer();
                while ((string3 = bufferedReader.readLine()) != null) {
                    stringBuffer.append(String.valueOf(string3) + "\n");
                }
                return stringBuffer.toString();
            }
            catch (Exception exception) {
                System.err.println("Error when trying to read " + string);
                exception.printStackTrace(System.err);
                return null;
            }
        }
        try {
            Reader reader = string.startsWith("ejs:") ? new CharArrayReader((char[])memory.get(string)) : new FileReader(string);
            LineNumberReader lineNumberReader = new LineNumberReader(reader);
            StringBuffer stringBuffer = new StringBuffer();
            String string4 = lineNumberReader.readLine();
            while (string4 != null) {
                stringBuffer.append(String.valueOf(string4) + "\n");
                string4 = lineNumberReader.readLine();
            }
            reader.close();
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            System.err.println("Error when trying to read " + string);
            exception.printStackTrace(System.err);
            return null;
        }
    }

    protected void extraAction2() {
    }

    protected void extraAction3() {
    }

    private static class EditorAndScroll {
        String name;
        JEditorPane editorPane;
        JScrollPane scrollPane;
        boolean visible = true;

        EditorAndScroll(String string, JEditorPane jEditorPane, JScrollPane jScrollPane) {
            this.name = string;
            this.editorPane = jEditorPane;
            this.scrollPane = jScrollPane;
        }

        public void setVisible(boolean bl) {
            this.visible = bl;
        }

        public boolean isVisible() {
            return this.visible;
        }
    }

    private static class MyXMLAccessory
    extends JPanel {
        private JRadioButton xmlButton = new JRadioButton("XML", true);

        public MyXMLAccessory(JFileChooser jFileChooser) {
            JRadioButton jRadioButton = new JRadioButton("BIN", false);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.xmlButton);
            buttonGroup.add(jRadioButton);
            this.setLayout(new BoxLayout(this, 1));
            this.add(new JLabel(ejsRes.getString("Simulation.StateFormat")));
            this.add(this.xmlButton);
            this.add(jRadioButton);
        }

        public boolean saveAsXML() {
            return this.xmlButton.isSelected();
        }
    }
}

