/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;

public class Grid
implements Drawable {
    protected int nx;
    protected int ny;
    protected double xmin;
    protected double xmax;
    protected double ymin;
    protected double ymax;
    protected double dx;
    protected double dy;
    protected Color color = new Color(200, 200, 200, 100);
    protected GeneralPath generalPath = new GeneralPath();
    protected boolean visible = true;

    public Grid(int n) {
        this(n, n, 0.0, n, 0.0, n);
    }

    public Grid(int n, int n2) {
        this(n, n2, 0.0, n, 0.0, n2);
    }

    public Grid(int n, int n2, double d, double d2, double d3, double d4) {
        this.nx = n;
        this.ny = n2;
        this.setMinMax(d, d2, d3, d4);
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public double getDx() {
        return this.dx;
    }

    public double getXMin() {
        return this.xmin;
    }

    public double getXMax() {
        return this.xmax;
    }

    public double getYMin() {
        return this.ymin;
    }

    public double getYMax() {
        return this.ymax;
    }

    public double getDy() {
        return this.dy;
    }

    public void setMinMax(double d, double d2, double d3, double d4) {
        this.generalPath.reset();
        this.xmin = (float)d;
        this.xmax = (float)d2;
        this.ymin = (float)d3;
        this.ymax = (float)d4;
        this.dx = this.nx > 0 ? (double)((float)((this.xmax - this.xmin) / (double)this.nx)) : 1.0;
        this.dy = this.ny > 0 ? (double)((float)((this.ymax - this.ymin) / (double)this.ny)) : 1.0;
        if (!this.visible) {
            return;
        }
        float f = (float)this.ymin;
        if (this.ny <= 512) {
            int n = 0;
            while (n <= this.ny) {
                this.generalPath.moveTo((float)this.xmin, f);
                this.generalPath.lineTo((float)this.xmax, f);
                f = (float)((double)f + this.dy);
                ++n;
            }
        }
        float f2 = (float)this.xmin;
        if (this.nx <= 512) {
            int n = 0;
            while (n <= this.nx) {
                this.generalPath.moveTo(f2, (float)this.ymin);
                this.generalPath.lineTo(f2, (float)this.ymax);
                f2 = (float)((double)f2 + this.dx);
                ++n;
            }
        }
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        if (Math.abs(drawingPanel.getXPixPerUnit() * (this.xmax - this.xmin) / (double)this.nx) < 4.0) {
            return;
        }
        if (Math.abs(drawingPanel.getYPixPerUnit() * (this.ymax - this.ymin) / (double)this.ny) < 4.0) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = drawingPanel.getPixelTransform();
        Shape shape = this.generalPath.createTransformedShape(affineTransform);
        graphics2D.setColor(this.color);
        graphics2D.draw(shape);
        graphics2D.setColor(Color.black);
    }

    public int[] getCellPoint(double d, double d2) {
        int n = 0;
        n = (int)Math.floor((d - this.xmin) / this.dx);
        n = Math.max(0, n);
        n = Math.min(this.nx, n);
        int n2 = 0;
        n2 = (int)Math.floor((d2 - this.ymin) / this.dy);
        n2 = Math.max(0, n2);
        n2 = Math.min(this.ny, n2);
        return new int[]{n, n};
    }

    public Point2D.Double getClosestGridPoint(double d, double d2) {
        int n = 0;
        n = (int)Math.round((d - this.xmin) / this.dx);
        n = Math.max(0, n);
        n = Math.min(this.nx, n);
        double d3 = this.xmin + this.dx * (double)n;
        n = (int)Math.round((d2 - this.ymin) / this.dy);
        n = Math.max(0, n);
        n = Math.min(this.ny, n);
        double d4 = this.ymin + this.dy * (double)n;
        return new Point2D.Double(d3, d4);
    }
}

