/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Measurable;
import org.opensourcephysics.display.OSPRuntime;

public class MeasuredImage
implements Measurable {
    protected BufferedImage image;
    protected double xmin;
    protected double xmax;
    protected double ymin;
    protected double ymax;
    protected boolean visible = true;

    public MeasuredImage() {
        this(null, 0.0, 0.0, 0.0, 0.0);
    }

    public MeasuredImage(BufferedImage bufferedImage) {
        this(bufferedImage, 0.0, bufferedImage.getWidth(), 0.0, bufferedImage.getHeight());
    }

    public MeasuredImage(BufferedImage bufferedImage, double d, double d2, double d3, double d4) {
        this.image = bufferedImage;
        this.xmin = d;
        this.xmax = d2;
        this.ymin = d3;
        this.ymax = d4;
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        if (this.image == null) {
            drawingPanel.setMessage(DisplayRes.getString("MeasuredImage.NoImage"));
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        if (!OSPRuntime.isMac()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        double d = (this.xmax - this.xmin) * drawingPanel.xPixPerUnit / (double)this.image.getWidth();
        double d2 = (this.ymax - this.ymin) * drawingPanel.yPixPerUnit / (double)this.image.getHeight();
        graphics2D.transform(AffineTransform.getTranslateInstance((double)drawingPanel.leftGutter + drawingPanel.xPixPerUnit * (this.xmin - drawingPanel.xmin), (double)drawingPanel.topGutter + drawingPanel.yPixPerUnit * (drawingPanel.ymax - this.ymax)));
        graphics2D.transform(AffineTransform.getScaleInstance(d, d2));
        graphics2D.drawImage((Image)this.image, 0, 0, drawingPanel);
        graphics2D.setTransform(affineTransform);
        graphics2D.setRenderingHints(renderingHints);
    }

    @Override
    public boolean isMeasured() {
        return this.image != null;
    }

    @Override
    public double getXMin() {
        return this.xmin;
    }

    @Override
    public double getXMax() {
        return this.xmax;
    }

    @Override
    public double getYMin() {
        return this.ymin;
    }

    @Override
    public double getYMax() {
        return this.ymax;
    }

    public void setXMin(double d) {
        this.xmin = d;
    }

    public void setXMax(double d) {
        this.xmax = d;
    }

    public void setYMin(double d) {
        this.ymin = d;
    }

    public void setYMax(double d) {
        this.ymax = d;
    }

    public void setMinMax(double d, double d2, double d3, double d4) {
        this.xmin = d;
        this.xmax = d2;
        this.ymin = d3;
        this.ymax = d4;
    }
}

