/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display2d.GridData;

public class GridPointData
implements GridData {
    protected double[][][] data;
    protected double left;
    protected double right;
    protected double bottom;
    protected double top;
    protected double dx = 0.0;
    protected double dy = 0.0;
    protected boolean cellData = false;
    protected String[] names;

    public GridPointData(int n, int n2, int n3) {
        if (n2 < 1 || n < 1) {
            throw new IllegalArgumentException("Number of dataset rows and columns must be positive. Your row=" + n2 + "  col=" + n);
        }
        if (n3 < 1) {
            throw new IllegalArgumentException("Number of 2d data components must be positive. Your ncomponents=" + n3);
        }
        this.data = new double[n][n2][n3 + 2];
        this.setScale(0.0, n, 0.0, n2);
        this.names = new String[n3];
        int n4 = 0;
        while (n4 < n3) {
            this.names[n4] = "Component_" + n4;
            ++n4;
        }
    }

    public GridPointData createGridPointData(int n) {
        GridPointData gridPointData = new GridPointData(this.data.length, this.data[0].length, n + 2);
        gridPointData.setScale(this.left, this.right, this.bottom, this.top);
        return gridPointData;
    }

    @Override
    public void setComponentName(int n, String string) {
        this.names[n] = string;
    }

    @Override
    public String getComponentName(int n) {
        return this.names[n];
    }

    @Override
    public int getComponentCount() {
        return this.data[0][0].length - 2;
    }

    @Override
    public void setScale(double d, double d2, double d3, double d4) {
        this.cellData = false;
        this.left = d;
        this.right = d2;
        this.bottom = d3;
        this.top = d4;
        int n = this.data.length;
        int n2 = this.data[0].length;
        this.dx = 0.0;
        if (n > 1) {
            this.dx = (this.right - this.left) / (double)(n - 1);
        }
        this.dy = 0.0;
        if (n2 > 1) {
            this.dy = (this.bottom - this.top) / (double)(n2 - 1);
        }
        double d5 = this.left;
        int n3 = 0;
        while (n3 < n) {
            double d6 = this.top;
            int n4 = 0;
            while (n4 < n2) {
                this.data[n3][n4][0] = d5;
                this.data[n3][n4][1] = d6;
                d6 += this.dy;
                ++n4;
            }
            d5 += this.dx;
            ++n3;
        }
    }

    @Override
    public void setCellScale(double d, double d2, double d3, double d4) {
        this.cellData = true;
        int n = this.data.length;
        int n2 = this.data[0].length;
        this.dx = 0.0;
        if (n > 1) {
            this.dx = (d2 - d) / (double)n;
        }
        this.dy = 0.0;
        if (n2 > 1) {
            this.dy = (d3 - d4) / (double)n2;
        }
        double d5 = d + this.dx / 2.0;
        int n3 = 0;
        while (n3 < n) {
            double d6 = d4 + this.dy / 2.0;
            int n4 = 0;
            while (n4 < n2) {
                this.data[n3][n4][0] = d5;
                this.data[n3][n4][1] = d6;
                d6 += this.dy;
                ++n4;
            }
            d5 += this.dx;
            ++n3;
        }
        this.left = d + this.dx / 2.0;
        this.right = d2 - this.dx / 2.0;
        this.bottom = d3 - this.dy / 2.0;
        this.top = d4 + this.dy / 2.0;
    }

    @Override
    public void setCenteredCellScale(double d, double d2, double d3, double d4) {
        int n = this.data.length;
        int n2 = this.data[0].length;
        double d5 = n > 1 ? (d2 - d) / (double)(n - 1) / 2.0 : 0.0;
        d -= d5;
        d2 += d5;
        d5 = n2 > 1 ? (d4 - d3) / (double)(n2 - 1) / 2.0 : 0.0;
        this.setCellScale(d, d2, d3 -= d5, d4 += d5);
    }

    @Override
    public boolean isCellData() {
        return this.cellData;
    }

    @Override
    public double getValue(int n, int n2, int n3) {
        return this.data[n][n2][n3 + 2];
    }

    @Override
    public void setValue(int n, int n2, int n3, double d) {
        this.data[n][n2][n3 + 2] = d;
    }

    @Override
    public int getNx() {
        return this.data.length;
    }

    @Override
    public int getNy() {
        return this.data[0].length;
    }

    @Override
    public double[] getZRange(int n) {
        double d;
        int n2 = 2 + n;
        double d2 = d = this.data[0][0][n2];
        int n3 = 0;
        int n4 = this.data.length;
        while (n3 < n4) {
            int n5 = 0;
            int n6 = this.data[0].length;
            while (n5 < n6) {
                double d3 = this.data[n3][n5][n2];
                if (d3 > d2) {
                    d2 = d3;
                }
                if (d3 < d) {
                    d = d3;
                }
                ++n5;
            }
            ++n3;
        }
        return new double[]{d, d2};
    }

    public double[] getVertex(double d, double d2) {
        int n = (int)Math.floor((d - this.left) / this.dx);
        n = Math.max(0, n);
        n = Math.min(n, this.data.length - 1);
        int n2 = (int)Math.floor(-(this.top - d2) / this.dy);
        n2 = Math.max(0, n2);
        n2 = Math.min(n2, this.data[0].length - 1);
        return this.data[n][n2];
    }

    @Override
    public double interpolate(double d, double d2, int n) {
        int n2 = (int)((d - this.data[0][0][0]) / this.dx);
        n2 = Math.max(0, n2);
        n2 = Math.min(this.data.length - 2, n2);
        int n3 = (int)((d2 - this.data[0][0][1]) / this.dy);
        n3 = Math.max(0, n3);
        n3 = Math.min(this.data[0].length - 2, n3);
        double d3 = (d - this.data[n2][n3][0]) / this.dx;
        double d4 = (d2 - this.data[n2][n3][1]) / this.dy;
        return (1.0 - d3) * (1.0 - d4) * this.data[n2][n3][n += 2] + d3 * (1.0 - d4) * this.data[n2 + 1][n3][n] + d3 * d4 * this.data[n2 + 1][n3 + 1][n] + (1.0 - d3) * d4 * this.data[n2][n3 + 1][n];
    }

    @Override
    public double[] interpolate(double d, double d2, int[] nArray, double[] dArray) {
        int n = (int)((d - this.data[0][0][0]) / this.dx);
        n = Math.max(0, n);
        n = Math.min(this.data.length - 2, n);
        int n2 = (int)((d2 - this.data[0][0][1]) / this.dy);
        n2 = Math.max(0, n2);
        n2 = Math.min(this.data[0].length - 2, n2);
        double d3 = (d - this.data[n][n2][0]) / this.dx;
        double d4 = (d2 - this.data[n][n2][1]) / this.dy;
        int n3 = 0;
        int n4 = nArray.length;
        while (n3 < n4) {
            int n5 = nArray[n3] + 2;
            dArray[n3] = (1.0 - d3) * (1.0 - d4) * this.data[n][n2][n5] + d3 * (1.0 - d4) * this.data[n + 1][n2][n5] + d3 * d4 * this.data[n + 1][n2 + 1][n5] + (1.0 - d3) * d4 * this.data[n][n2 + 1][n5];
            ++n3;
        }
        return dArray;
    }

    @Override
    public double[][][] getData() {
        return this.data;
    }

    public void setData(double[][][] dArray) {
        this.data = dArray;
        int n = this.data.length - 1;
        int n2 = this.data[0].length - 1;
        this.left = this.data[0][0][0];
        this.right = this.data[n][n2][0];
        this.top = this.data[0][0][1];
        this.bottom = this.data[n][n2][1];
        this.dx = (this.right - this.left) / (double)n;
        this.dy = (this.bottom - this.top) / (double)n2;
        this.cellData = false;
    }

    @Override
    public final double getLeft() {
        return this.left;
    }

    @Override
    public final double getRight() {
        return this.right;
    }

    @Override
    public final double getTop() {
        return this.top;
    }

    @Override
    public final double getBottom() {
        return this.bottom;
    }

    @Override
    public final double getDx() {
        return this.dx;
    }

    @Override
    public final double getDy() {
        return this.dy;
    }

    @Override
    public double indexToX(int n) {
        return this.data == null || n >= this.data.length ? Double.NaN : this.data[n][0][0];
    }

    @Override
    public double indexToY(int n) {
        return this.data == null || n >= this.data[0].length ? Double.NaN : this.data[0][n][1];
    }

    @Override
    public int xToIndex(double d) {
        if (this.data == null) {
            return 0;
        }
        int n = this.getNx();
        double d2 = (this.right - this.left) / (double)n;
        int n2 = (int)((d - this.left) / d2);
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= n) {
            return n - 1;
        }
        return n2;
    }

    @Override
    public int yToIndex(double d) {
        if (this.data == null) {
            return 0;
        }
        int n = this.getNy();
        double d2 = (this.top - this.bottom) / (double)n;
        int n2 = (int)((this.top - d) / d2);
        if (n2 < 0) {
            return 0;
        }
        if (n2 >= n) {
            return n - 1;
        }
        return n2;
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    private static class Loader
    extends XMLLoader {
        private Loader() {
        }

        @Override
        public void saveObject(XMLControl xMLControl, Object object) {
            GridPointData gridPointData = (GridPointData)object;
            xMLControl.setValue("left", gridPointData.left);
            xMLControl.setValue("right", gridPointData.right);
            xMLControl.setValue("bottom", gridPointData.bottom);
            xMLControl.setValue("top", gridPointData.top);
            xMLControl.setValue("dx", gridPointData.dx);
            xMLControl.setValue("dy", gridPointData.dy);
            xMLControl.setValue("is cell data", gridPointData.cellData);
            xMLControl.setValue("data", gridPointData.data);
        }

        @Override
        public Object createObject(XMLControl xMLControl) {
            return new GridPointData(1, 1, 1);
        }

        @Override
        public Object loadObject(XMLControl xMLControl, Object object) {
            GridPointData gridPointData = (GridPointData)object;
            double[][][] dArray = (double[][][])xMLControl.getObject("data");
            gridPointData.data = dArray;
            gridPointData.left = xMLControl.getDouble("left");
            gridPointData.right = xMLControl.getDouble("right");
            gridPointData.bottom = xMLControl.getDouble("bottom");
            gridPointData.top = xMLControl.getDouble("top");
            gridPointData.dx = xMLControl.getDouble("dx");
            gridPointData.dy = xMLControl.getDouble("dy");
            gridPointData.cellData = xMLControl.getBoolean("is cell data");
            return object;
        }
    }
}

